Code cleanup strategy:

Create new repository
Redesign of repository
Network
    Localize all network changes to ONLY refer to neural network components, isolating as much of it from the other parts of the code
    Distinguish by network types: 
        distributional: uses another model and outputs mean and variance
        cluster: image to flat
        flat: flat inputs to outputs
        object-based: factored inputs to factored outputs
        Pair: single plus factored inputs to factored outputs
        convolutional: image to flat
Environment
    Localize the environment changes to match gym EXCEPT for interaction related components
    step
    get_interaction
    set_state(setting as factored state)
Hyperparams:
    Use the same hyperparameter system, just remove the RL specific hyperparmeters
Utils
    normalization:
        pad_append_normalize: factored-normalized
    extractors:
        factored-flat
        flat-factored
        single target
        all single target
        pair-representation
Interaction Model: merge all logic related to a particular component:
    Create different models for different situations with the same kind of input
    initialize model (args) -> abstracted model
        creates the appropriate extractors
    model (batch, types) -> batch
        input: all state, all target state
        output: forward logits, masks (logits, sampled of all types), input, distributions
    A base model is constructed out of a collection of submodels, but each computation has to be performed by a separate submodel
        model(batch, mask=None) -> result 
            the input mask here is not the one generated by the model, but multiplied with whatever mask is generated by the model
    submodels:
        passive only
        pairwise active only
        with input masks:
            full (many to one)
            paired input (one plus many to one)
            all (many to many)
            all-full combined
Interaction Compute: function class
    simplify base model by moving model parameters to a single dict
    init(args, model) -> abstracted compute operator
    compute_interaction(self, batch, types) -> output batch with: generated masks, forward distributions, wrapped inputs for gradients, target values, output distributions
        fill in the values if there is any shared computation by passing in the results
    subclasses of compute:
        null
        gradient
        soft masking
        mixed masking
        hard masking
        counterfactual
        attention
Trainer:
    Manages the non-core training components (weighting, lambda schedules)
    update_weights
logging:
    takes in the results and outputs the approrpiate printouts
    strategy: merge and copy the loggers, taking in the results and generating keys and values out of them
Training:
    compute the difference
    training abstraction: general train(args, buffer, logging) -> model updates, uses a for loop that calls the trainer, the appropriate train types, and the logger

    Training types:
        passive training
        full active training
        combined full training
        all training
        EM training
    strategy: create a single training loop that can select each of these procedures as subfiles. Base it off of EM training since that is the most complicated.
Buffer abstraction:
    sample(size, all, weights) -> batch of keys
    getitem[indices]
    expected keys: full obs, full target obs, 
    Strategy: take the all buffer and then figure out the general abstractions necessary
Merge granger, all, multi, full and EM into a single folder
Abstract the data structure so that we can use either Tianshou or a different data struture
Simplify causal training modes and merge logic
How to run:
Create data: replace the record-rollouts argument with the path to store the data

Install commands:


# Installation creating conda environment 
- conda create -n obj python=3.8
- conda activate obj
# Installing Robosuite with pushing domain (from source)
- git clone git@github.com:/robosuite-pushing.git
- conda activate obj
- cd robosuite
<!-- - copy mujoco download to: ~/.mujoco/mujoco200
- copy mujoco key to ~/.mujoco/mjkey.txt -->
- pip install -r requirements.txt
https://robosuite.ai/docs/installation.html
# Installing Air Hockey domain (from source)
- git clone git@github.com:/air-hockey-rl.git
- conda activate obj
- cd air-hockey-rl
- pip install -e .[train]
# install remaining components
- conda install pytorch torchvision torchaudio cudatoolkit=10.2 -c pytorch
- conda install pytorch torchvision torchaudio pytorch-cuda=11.7 -c pytorch -c nvidia
- conda install pybox2d -c conda-forge
- pip install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu121
- pip install torch==2.0.1 torchvision==0.15.2 torchaudio==2.0.2
- pip install tianshou / pip install git+https://github.com/thu-ml/tianshou.git@master --upgrade
- pip install opencv-python imageio psutil pyyaml wandb gymnasium tqdm
# install GNN components
- pip install torch_geometric
possibly necessary:
- pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.0.0+cu118.html
- pip install pyg_lib torch_scatter torch_sparse torch_cluster torch_spline_conv -f https://data.pyg.org/whl/torch-2.2.0+cu121.html
- https://pytorch-geometric.readthedocs.io/en/latest/install/installation.html#installation-from-wheels

# box2d:
- conda create -n pybox2d -c conda-forge python=3.8 pybox2d
alternatively, pip install pybox2d

( run above commands in box2d)

# Instructions on Running
- Generate data for the desired domain. If the code has been changed, new data might need to be generated for that domain. Use the commands below for generating random action data
- Find the config file corresponding to the desired task. To find the right parameters to change, look in Hyperparam/Argesets/full_args
- Either directly modify the file with the desired experiment, or better practice is to create a meta file by copying an existing meta file, and modifying the parameter there
- Generate the bash file with: python create_config_sweep.py configs/(path)
- run the bashes, or copy the desired line from the bash file to debug
- If unfinished, record TODOs here: 
- TODO: Need to test JACI, append masks. JACI is not performing well for some reason, so we need to confirm performance first
- TODO: Need to test regularizers, expectile style loss for performance. Test additive dynamics, Additive outcomes, consistency loss. Test partial and random masking, all in null_comp_gen
- TODO: energy based models, quantized models, particle models, mutual information, mixture of experts, distributional masking, plasticity, distillation, tree methods, 

# Generate Random vectors data
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/1_in/ --num-frames 500000 --variant 1-in > logs/JACI/1_in_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/2_in/ --num-frames 500000 --variant 2-in > logs/JACI/2_in_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/3_in/ --num-frames 500000 --variant 3-in > logs/JACI/3_in_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/4_in/ --num-frames 1000000 --variant 4-in > logs/JACI/4_in_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/many_in/ --num-frames 2000000 --variant many-in > logs/JACI/many_in_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/1_rare/ --num-frames 500000 --variant 1-rare > logs/JACI/1_rare_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/2_rare/ --num-frames 500000 --variant 2-rare > logs/JACI/2_rare_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/3_rare/ --num-frames 500000 --variant 3-rare > logs/JACI/3_rare_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/4_rare/ --num-frames 1000000 --variant 4-rare > logs/JACI/4_rare_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/many_rare/ --num-frames 2000000 --variant many-rare > logs/JACI/many_rare_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/2_chain/ --num-frames 1000000 --variant 2-chain > logs/JACI/2_chain_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/3_chain/ --num-frames 1000000 --variant 3-chain > logs/JACI/3_chain_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/2_multi-chain/ --num-frames 1000000 --variant 2-multi-chain > logs/JACI/2_multi-chain_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/3_multi_chain/ --num-frames 1000000 --variant 3-multi-chain > logs/JACI/3_multi_chain_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/multi_in/ --num-frames 1000000 --variant multi-in > logs/JACI/multi_in_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/1_hdim/ --num-frames 1000000 --variant 1-hdim > logs/JACI/1_in_hdim_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/1_in_ndym/ --num-frames 500000 --variant 1-in-ndym > logs/JACI/1_in_ndym_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/1_in_nt/ --num-frames 500000 --variant 1-in-nt > logs/JACI/1_in_nt_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/1_in_nl/ --num-frames 500000 --variant 1-in-nl > logs/JACI/1_in_nl_gen.txt
- python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/2_in_nl/ --num-frames 500000 --variant 2-in-nl > logs/JACI/2_in_nl_gen.txt

<!-- Generate Null data
python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/1_in_n/ --num-frames 500000 --variant 1-in-n > logs/null/1_in_n_gen.txt
python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/2_in_n/ --num-frames 500000 --variant 2-in-n > logs/null/2_in_n_gen.txt
python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/3_in_n/ --num-frames 500000 --variant 3-in-n > logs/null/3_in_n_gen.txt
python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/4_in_n/ --num-frames 500000 --variant 4-in-n > logs/null/4_in_n_gen.txt
python generate_random.py --env RandomDAG --record-rollouts /hdd/datasets/object_data/RandomDAG/many_in_n/ --num-frames 500000 --variant many-in-n > logs/null/many_in_n_gen.txt -->

# Generate Box2D data
Box2d environments
- for debugging add flags: --render --display-frame
- for rendering the masks, set --render --render-masks
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/1_ball_poly/ --num-frames 10000000 --variant 1-ball-poly --horizon 100 > logs/null/box2d/1_ball_poly.txt
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/default/ --num-frames 10000000 --variant default --horizon 100 > logs/null/box2d/default.txt
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/1_ctrl_poly/ --num-frames 10000000 --variant 1-ctrl-poly --horizon 100 > logs/null/box2d/1_ctrl_poly.txt
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/goal_ctrl_target/ --num-frames 5000000 --variant goal-ctrl-target  --horizon 100 > logs/null/goal_ctrl_target.txt &
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/goal_ctrl_target_hard/ --num-frames 5000000 --variant goal-ctrl-target-hard  --horizon 100 > logs/null/goal_ctrl_target_hard.txt &
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/goal_ctrl_target_vel/ --num-frames 5000000 --variant goal-ctrl-target-vel  --horizon 100 > logs/null/goal_ctrl_target_vel.txt &
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/goal_ctrl_target_very_hard/ --num-frames 5000000 --variant goal-ctrl-target-very-hard  --horizon 100 > logs/null/goal_ctrl_target_very_hard.txt &
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/goal_ctrl_target_obstacles/ --num-frames 5000000 --variant goal-ctrl-target-obstacles  --horizon 100 > logs/null/goal_ctrl_target_obstacles.txt &

# Box2d All Environments
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/1_ball_poly_all/ --num-frames 1000000 --variant 1-ball-poly-all --horizon 100 > logs/JACI/box2d/1_ball_poly.txt &
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/1_ctrl_all/ --num-frames 1000000 --variant 1-ctrl-all --horizon 100 > logs/JACI/box2d/1_ctrl.txt &
- python generate_random.py --env Box2D --record-rollouts /hdd/datasets/object_data/box2d/default_all/ --num-frames 10000000 --variant default-all --horizon 100 > logs/JACI/box2d/default.txt &


# Phyre environments
- python generate_random.py --env Phyre --record-rollouts /hdd/datasets/object_data/phyre/single/ --num-frames 1000000 --variant single > logs/null/phyre/single_gen.txt

# Breakout
- python generate_random.py --env Breakout --record-rollouts /hdd/datasets/object_data/breakout/tiny/ --num-frames 1000000 --variant rand_tiny --horizon 100 > logs/breakout/tiny_gen.txt

# Pusher 2D
- python generate_random.py --env Pusher2D --record-rollouts /hdd/datasets/object_data/pusher2d/tiny/ --num-frames 1000000 --variant tiny --horizon 100 > logs/pusher2d/tiny_gen.txt

# Gym Pusher
- python generate_random.py --env GymPusher --record-rollouts /hdd/datasets/object_data/gympusher/default --num-frames 1000000 --variant default --horizon 100 > logs/gympusher/default_gen.txt

# Robosuite Pusher
- python generate_random.py --env RoboPushing --record-rollouts /hdd/datasets/object_data/robopush/default --num-frames 1000000 --variant default --horizon 100 > logs/robopush/default_gen.txt

# Air Hockey
- python generate_random.py --env AirHockey --record-rollouts /hdd/datasets/object_data/air_hockey/default --num-frames 1000000 --variant default --horizon 300 > logs/air/default_gen.txt
- python generate_random.py --env AirHockey --record-rollouts /hdd/datasets/object_data/air_hockey/hard --num-frames 1000000 --variant hard --horizon 300 > logs/air/hard_gen.txt
- python generate_random.py --env AirHockey --record-rollouts /hdd/datasets/object_data/air_hockey/obstacles --num-frames 1000000 --variant obstacles --horizon 300 > logs/air/obstacles_gen.txt

# Run training for an individual experiment: replace the appropriate arguments with the path you want to load data and store outputs
<!-- python train_all_interaction.py --config configs/Null/RandomDAG/1_in/1_in_full.yaml -->
- python train_all_interaction.py --config configs/JACI/RandomDAG/1_in/1_in.yaml

# Run mass experiments
- python create_config_sweep.py configs/JACI/RandomDAG/meta/jaci_env.yaml
- bash bashes/jaci_env.sh
- python create_config_sweep.py configs/JACI/box2d/meta/jaci_b2d_env.yaml
- bash bashes/jaci_b2d_env.sh
- python create_config_sweep.py configs/JACI/breakout/meta/jaci_breakout_env.yaml
- bash bashes/jaci_breakout_env.sh
- python create_config_sweep.py configs/JACI/pusher2d/meta/jaci_pusher2d_env.yaml
- bash bashes/jaci_pusher2d_env.sh

# Generate exhaustive outputs
- python eval_exhaustive.py --env Pusher1D --use-counterfactual --use-zero --alpha 0.01 0.4 --use-witness
-   python create_table.py logs/exhaustive/Pusher1D_0.01_0.4.txt Mover Obstacle Outcome
- python eval_exhaustive.py --env ForestFire --use-counterfactual --use-zero --alpha 0.01 0.2 --use-witness
-   python create_table.py logs/exhaustive/ForestFire_0.01_0.2.txt April May June Fire
- python eval_exhaustive.py --env GangShoot --use-counterfactual --use-zero --alpha 0.01 1.0 --use-witness
-   python create_table.py logs/exhaustive/GangShoot_0.01_1.0.txt Gang Leader Death
- python eval_exhaustive.py --env RockThrowing --alpha 0.01 1.0 --use-witness
-   python create_table.py logs/exhaustive/RockThrowing_0.01_1.0.txt SH ST BH BT BoS
- python eval_exhaustive.py --env HaltCharge --use-counterfactual --use-zero --alpha 0.01 0.3 --use-witness
-   python create_table.py logs/exhaustive/HaltCharge_0.01_0.3.txt Major Sergeant Corporal
- python eval_exhaustive.py --env ModDAG --variant and --use-counterfactual --use-zero --alpha 0.01 1.0 --use-witness
-   python create_table.py logs/exhaustive/ModDAG_and0.01_1.0.txt A B C
- python eval_exhaustive.py --env ModDAG --variant or --use-counterfactual --use-zero --alpha 0.01 1.0 --use-witness
-   python create_table.py logs/exhaustive/ModDAG_or0.01_1.0.txt A B C
- python eval_exhaustive.py --env ModDAG --variant xor --use-counterfactual --use-zero --alpha 0.01 1.0 --use-witness
-   python create_table.py logs/exhaustive/ModDAG_xor0.01_1.0.txt A B C
- python eval_exhaustive.py --env Train --use-zero --alpha 0.01 1.0 --use-witness
-   python create_table.py logs/exhaustive/Train_0.01_1.0.txt Break Switch Track Arrive
